/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments.region;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.commands.MarkerCommands;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AbstractArea;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.StickUtil;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ContainingOwnedRegionArgumentType
implements ArgumentType<String> {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z]+[A-Za-z\\d\\-]+[A-Za-z\\d]+$");
    private static final Collection<String> EXAMPLES = Stream.of("spawn", "arena4pvp", "shop", "nether-hub").collect(Collectors.toSet());
    private static final SimpleCommandExceptionType ERROR_AREA_INVALID = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"cli.arg.region.parse.invalid", (String)"Unable to parse region name!"));
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(regionName -> class_2561.method_48322((String)"cli.arg.region.invalid", (String)"Region '%s' does not exist", (Object[])new Object[]{regionName}));
    private static final DynamicCommandExceptionType ERROR_INVALID_PARENT = new DynamicCommandExceptionType(regionName -> class_2561.method_48322((String)"cli.arg.region.owned.invalid", (String)"Region '%s' is not suitable as parent", (Object[])new Object[]{regionName}));

    public static ContainingOwnedRegionArgumentType owningRegions() {
        return new ContainingOwnedRegionArgumentType();
    }

    public static IMarkableRegion getRegion(CommandContext<class_2168> context, String argName) throws CommandSyntaxException {
        String containingRegionName = (String)context.getArgument(argName, String.class);
        String containedRegionName = (String)context.getArgument(CommandConstants.NAME.toString(), String.class);
        DimensionRegionCache dimCache = RegionDataManager.get().cacheFor((class_5321<class_1937>)((class_2168)context.getSource()).method_9225().method_27983());
        IMarkableRegion parent = dimCache.getRegion(containingRegionName);
        IMarkableArea markedArea = ContainingOwnedRegionArgumentType.markableArea(context);
        if (markedArea == null) {
            throw new IllegalArgumentException("Could not get marked blocks from command");
        }
        if (parent == null) {
            throw ERROR_INVALID_VALUE.create((Object)containingRegionName);
        }
        boolean hasPermissionForParent = Permissions.get().hasConfigPermission((class_2168)context.getSource(), CommandSourceType.of((class_2168)context.getSource()));
        boolean containsChild = parent.getArea().containsOther(markedArea);
        if (hasPermissionForParent && containsChild) {
            return parent;
        }
        if (!hasPermissionForParent) {
            MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_48322((String)"cli.arg.region.owned.invalid.permission", (String)"Region %s is not suitable as parent for %s (no permission for parent)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        if (!containsChild) {
            MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_48322((String)"cli.arg.region.owned.invalid.containment", (String)"Region %s is not suitable as parent for %s (does not fully contain child region)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        throw ERROR_INVALID_PARENT.create((Object)containingRegionName);
    }

    public static IMarkableRegion getRegionWithMarker(CommandContext<class_2168> context, String argName) throws CommandSyntaxException {
        String containingRegionName = (String)context.getArgument(argName, String.class);
        String containedRegionName = (String)context.getArgument(CommandConstants.NAME.toString(), String.class);
        DimensionRegionCache dimCache = RegionDataManager.get().cacheFor((class_5321<class_1937>)((class_2168)context.getSource()).method_9225().method_27983());
        IMarkableRegion parent = dimCache.getRegion(containingRegionName);
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        IMarkableRegion markedRegion = MarkerCommands.fromMarkedBlocks(context, (class_1657)player, containedRegionName);
        if (markedRegion == null) {
            throw new IllegalArgumentException("Could not get marked blocks from command");
        }
        if (parent == null) {
            throw ERROR_INVALID_VALUE.create((Object)containingRegionName);
        }
        boolean hasPermissionForParent = Permissions.get().hasConfigPermission((class_2168)context.getSource(), CommandSourceType.of((class_2168)context.getSource()));
        boolean containsChild = parent.getArea().containsOther(markedRegion.getArea());
        if (hasPermissionForParent && containsChild) {
            return parent;
        }
        if (!hasPermissionForParent) {
            MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_48322((String)"cli.arg.region.owned.invalid.permission", (String)"Region %s is not suitable as parent for %s (no permission for parent)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        if (!containsChild) {
            MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_48322((String)"cli.arg.region.owned.invalid.containment", (String)"Region %s is not suitable as parent for %s (does not fully contain child region)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        throw ERROR_INVALID_PARENT.create((Object)containingRegionName);
    }

    @Nullable
    private static IMarkableArea markableArea(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        AbstractArea markedArea = null;
        AreaType areaType = null;
        if (ctx.getInput().contains(AreaType.CUBOID.areaType)) {
            areaType = AreaType.CUBOID;
        }
        if (ctx.getInput().contains(AreaType.SPHERE.areaType)) {
            areaType = AreaType.SPHERE;
        }
        switch (areaType) {
            case CUBOID: {
                class_2338 p1 = class_2262.method_9697(ctx, (String)CommandConstants.POS1.toString());
                class_2338 p2 = class_2262.method_9697(ctx, (String)CommandConstants.POS2.toString());
                markedArea = new CuboidArea(p1, p2);
                break;
            }
            case SPHERE: {
                try {
                    class_2338 centerPos = class_2262.method_9697(ctx, (String)CommandConstants.CENTER_POS.toString());
                    int radius = IntegerArgumentType.getInteger(ctx, (String)CommandConstants.RADIUS.toString());
                    markedArea = new SphereArea(centerPos, radius);
                }
                catch (CommandSyntaxException cse) {
                    class_2338 centerPos = class_2262.method_9697(ctx, (String)CommandConstants.CENTER_POS.toString());
                    class_2338 radiusPos = class_2262.method_9697(ctx, (String)CommandConstants.RADIUS_POS.toString());
                    markedArea = new SphereArea(centerPos, radiusPos);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)areaType));
            }
        }
        return markedArea;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && String.valueOf(reader.peek()).matches(Pattern.compile("^[A-Za-z\\d\\-]$").pattern())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            boolean isValidName = s.matches(VALID_NAME_PATTERN.pattern());
            if (isValidName) {
                return s;
            }
            throw new IllegalArgumentException("Invalid region name supplied");
        }
        catch (IllegalArgumentException argumentException) {
            reader.setCursor(i);
            Constants.LOGGER.error("Error parsing region name");
            throw ERROR_AREA_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestionsWithMarker(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            try {
                class_2487 stickNBT;
                class_3222 player = src.method_9207();
                class_1799 maybeStick = player.method_6047();
                if (StickUtil.isMarker(maybeStick) && (stickNBT = StickUtil.getStickNBT(maybeStick)) != null) {
                    MarkerStick marker = new MarkerStick(stickNBT);
                    if (!marker.isValidArea()) {
                        return Suggestions.empty();
                    }
                    IMarkableArea markedArea = StickUtil.getMarkedArea(player.method_6047());
                    LocalRegions.RegionOverlappingInfo overlapping = LocalRegions.getOverlappingWithPermission(markedArea, (class_1657)player);
                    if (!overlapping.hasContaining()) {
                        MessageSender.overLayMessage((class_1657)src.method_44023(), class_2561.method_48321((String)"cli.arg.area.marked.no-containment", (String)"No containing region available as parent for marked area."));
                        return Suggestions.empty();
                    }
                    Set containingRegionName = overlapping.containingRegions.stream().map(IProtectedRegion::getName).collect(Collectors.toSet());
                    return class_2172.method_9265(containingRegionName, (SuggestionsBuilder)builder);
                }
                return Suggestions.empty();
            }
            catch (CommandSyntaxException e) {
                Constants.LOGGER.error((Object)e);
                return Suggestions.empty();
            }
        }
        return Suggestions.empty();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            CommandContext<S> ctx = context;
            try {
                LocalRegions.RegionOverlappingInfo overlapping;
                IMarkableArea markedArea = ContainingOwnedRegionArgumentType.markableArea(ctx);
                if (markedArea == null) {
                    throw new IllegalArgumentException("Could not get marked blocks from command");
                }
                try {
                    class_3222 player = src.method_9207();
                    overlapping = LocalRegions.getOverlappingWithPermission(markedArea, (class_1657)player);
                }
                catch (CommandSyntaxException e) {
                    overlapping = LocalRegions.getOverlappingRegions(markedArea, (class_5321<class_1937>)src.method_9225().method_27983());
                }
                if (!overlapping.hasContaining()) {
                    if (src.method_43737()) {
                        MessageSender.overLayMessage((class_1657)src.method_44023(), class_2561.method_48321((String)"cli.arg.area.owned.no-containment", (String)"No containing region available as parent for given area."));
                        return Suggestions.empty();
                    }
                    MessageSender.sendCmdFeedback(src, class_2561.method_48321((String)"cli.arg.area.owned.no-containment", (String)"No containing region available as parent for given area."));
                    return Suggestions.empty();
                }
                Set containingRegionName = overlapping.containingRegions.stream().map(IProtectedRegion::getName).collect(Collectors.toSet());
                return class_2172.method_9265(containingRegionName, (SuggestionsBuilder)builder);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

